/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_42_h__
#define __REG_42_h__

/* ***********************************************************************
   *                                                                     *
   * regx42.h                                                            *
   * Tilmann Wendel , BID R&D, 13. Jan. 1998                             *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   * lockable set functions (preparations AND programming of sequencer)  *
   *                        (performance sequencer!!)                    *
   ***********************************************************************
*/


#include "regxdir.h"   /* contains CMD_MERGE and CMDG_PROTOCOLSET_0 */


#define MERGE_PERFSET_0(cmd)	CMD_MERGE (CMDG_PERFORMANCESET_0, cmd)

/* BestPerfSeqProg() */
#define CMDM_PERF_SEQPROG	0x05
#define CMD_PERF_SEQPROG	MERGE_PERFSET_0 (CMDM_PERF_SEQPROG)
#define IN_PERF_SEQPROG		4
#define OUT_PERF_SEQPROG	0

/* BestPerfSeqGenPropSet() */
#define CMDM_PERFSEQ_GENPROPSET	0x06
#define CMD_PERFSEQ_GENPROPSET	MERGE_PERFSET_0 (CMDM_PERFSEQ_GENPROPSET)
#define IN_PERFSEQ_GENPROPSET	12   /* measure and property and value */
#define OUT_PERFSEQ_GENPROPSET	0

/* BestPerfSeqTranPropSet() */
#define CMDM_PERFSEQ_TRANPROPSET	0x08
#define CMD_PERFSEQ_TRANPROPSET		MERGE_PERFSET_0 (CMDM_PERFSEQ_TRANPROPSET)
#define IN_PERFSEQ_TRANPROPSET		16 /* transient, prop and propvalue */
#define OUT_PERFSEQ_TRANPROPSET		0

/* BestPerfSeqTranCondPropSet() */
#define CMDM_PERFSEQ_TRANCONDPROPSET	0x0a
#define CMD_PERFSEQ_TRANCONDPROPSET	MERGE_PERFSET_0 (CMDM_PERFSEQ_TRANCONDPROPSET)
#define IN_PERFSEQ_TRANCONDPROPSET	B_LENGTH_NEGOTIATE
#define OUT_PERFSEQ_TRANCONDPROPSET	0

/* BestPerfSeqPropDefaultSet() */
#define CMDM_PERFSEQ_PROPDEFAULTSET	0x0b
#define CMD_PERFSEQ_PROPDEFAULTSET	MERGE_PERFSET_0 (CMDM_PERFSEQ_PROPDEFAULTSET)
#define IN_PERFSEQ_PROPDEFAULTSET	4
#define OUT_PERFSEQ_PROPDEFAULTSET	0

/* BestPerfSeqTranPropDefaultSet() */
#define CMDM_PERFSEQ_TRANPROPDEFAULTSET	0x0c
#define CMD_PERFSEQ_TRANPROPDEFAULTSET	MERGE_PERFSET_0 (CMDM_PERFSEQ_TRANPROPDEFAULTSET)
#define IN_PERFSEQ_TRANPROPDEFAULTSET	8
#define OUT_PERFSEQ_TRANPROPDEFAULTSET	0

#endif
